<!DOCTYPE html>
<html>
<head>
	<title>Ventas Online</title>
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="shortcut icon" href="../lib/images/favicon.png" />
    <script type="text/javascript" src="../js/jquery-3.2.1.js"></script>
    <script src="../js/jquery-ui.min.js"></script>
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.css">
    
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" >
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script type="text/javascript" src="../js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/lib/js/sweetalert.js"></script>

		<link rel="stylesheet" type="text/css" href="/lib/css/sweetalert.css" /> 
    <style type="text/css">
    	.degrade {		    
		    background: linear-gradient(180deg, rgba(0, 0, 0, 0.65) 0%, rgba(0, 0, 0, 0.29) 50%, rgba(49, 49, 49, 0.08) 100%);
		}
		.paso_3{}
    </style>
</head>

<body>
<div class="degrade">
	<div class="container text-center">
		
			<a href="https://andeanlodges.com/es">
				<img src="https://andeanlodges.com/wp-content/themes/andeanlodges.com-v2.0/assets/logos/logo.png" alt="Andean Lodges Logo" width="200">
			</a>
	</div>
</div>
<div class="container border border-secondary position-relative">
	<p class="text-center h4">
	<input type="hidden" id="se_codigo" value="<?= $servicio->se_codigo?>">
	<i class="fa fa-arrow-right text-secondary"></i> <span id="se_nombre">
		
	<?= $servicio->se_nombre ?>
	</span>
	</p>
	<div class="border mt-4 mb-2 p-2 rounded-pill text-center">
		<span class=""> <span id="marcador_1" class="rounded-circle bg-secondary border pl-2 pr-2 marcador">1</span> Seleccionar</span> <span> <span id="marcador_2" class="rounded-circle border pl-2 pr-2 marcador">2</span> Llenar</span> <span id="marcador_3" class="rounded-circle border pl-2 pr-2 marcador">3</span> Finalizar y Pagar</span>
	</div>
	<div id="paso_1" class="w-100">
		<div class="row">
			<div class="col-md-3"></div>
			<div class="col-md-6">
					
					<div class="bg-secondary text-white small p-4 border-1 rounded my-2">
			1. Seleccione la fecha en la que desea iniciar el servicio.<br />
2. Haga clic sobre el botón "Reservar" en la fila correspondiente, de acuerdo a la cantidad de personas que viajan en su grupo. Recuerde que si su grupo tiene 4 o más integrantes, el precio por persona es el mismo
		</div>
		<div class="input-group mt-2">
			<div class="input-group-text">
				Fecha de Viaje:
			</div>
			<input type="text" name="f" id="f" class="form-control"  onchange="cambiar_fecha_viaje()" value="<?= $fecha->f ?>">
			<div class="input-group-text"><i class="fa fa-calendar-alt"></i></div>
		</div>
		
		<div class="table-responsive">
			<table id="t_tarifas" class="table">
				<thead>
					<tr>
						<th class="text-center">GRUPO<br><i class="fa fa-users"></i></th>
						<th class="text-center">PRECIO<br>X<i class="fa fa-user"></i></th>
						<th class="text-center">PRECIO<br>TOTAL</th>
						<th class="text-center"></th>
					</tr>
				</thead>
				<tbody>
					<? 
						$html_tarifas='';
						if ($tarifas) {
								# code...
							foreach ($tarifas as $tarifa) {
								$paxs=$tarifa->ta_numero_paxs_a;
								$costo = $tarifa->ta_costo_publico;
								$costo_total=$costo*$paxs;
								$html_tarifas.='<tr><td class="text-center">x'.$paxs.'<i class="fa fa-users"></i></td><td class="text-center">US$ '.$costo.'</td><td class="text-center"><b>US$ '.number_format( $costo_total,2).'</b></td><td class="text-center"><span class="btn btn-primary rounded-pill" onclick="ordenar_compra('.$paxs.','.$costo.')" >Reserva</span></td></tr>';
							}
						}else{
							$html_tarifas='<tr><td class="text-center" colspan="4">No se encontraron tarifas disponible para la fecha seleccionada</td></tr>';
						}
						echo $html_tarifas;
					?>
				</tbody>
			</table>
		</div>		

			</div>
			<div class="col-md-3"></div>
		</div>
		
	</div>
	<div id="paso_2" class="container" style="display: none; position: absolute;">
		<div id="detalles">
		<table class="table">
			<thead>
				<tr>
					<th>CANT</th>
					<th>SERVICIO</th>
					<th>PRECIO</th>
				</tr>
			</thead>
			<tbody>
				
			</tbody>
			<tfoot>
				<tr>
					<td align="right" colspan="2">TOTAL</td>
					<td class="costo_total" align="right"></td>
				</tr>
			</tfoot>
		</table>
	</div>
	<div class="text-center">
		<span class="btn btn-secondary" onclick="ordenar_compra()">ordenar mi pedido</span>
	</div>
</div>
<div id="paso_3" style="display: none;" class="w-100" >
	<div class="row">
		<div class="col-md-3"></div>
		<div class="col-md-6">
					<div class="bg-primary p-2 text-white text-center">      
			 <i class="fa fa-chevron-circle-left btn float-left text-white fa-2x rounded-circle" onclick="ventana_seleccionar()" style="margin-top:-10px " ></i> DETALLE DEL PEDIDO
		</div>
		
		<div class="container p-4 bg-light">
			
				<form id="po_promulario">

          <input type="hidden" name="cantidad_adultos_extranjero" id="cantidad_adultos_extranjero">
         
          <div id="da_comprobante_datos" class="d-none">
            <span class="beba">RUC:</span>
              <input type="text" name="da_comprobante_ruc" class="form-control">
            <span class="beba">RAZON SOCIAL:</span>
              <input type="text" name="da_comprobante_razon_social" class="form-control">
            <span class="beba">DIRECCION:</span>
              <textarea name="da_comprobante_direccion" class="w-100" rows="4"></textarea>
          </div>
					<h5 class="beba text-primary mt-2">INFORMACION PERSONAL</h5>
					<div class="input-group mb-0">
						 <div class="input-group-prepend">
						    <span class="input-group-text d-block" id="nombre" style="width: 120px;">Nombres</span>
						 </div>
						 <input type="text" id="da_cli_nombre" class="form-control" placeholder="nombres" aria-label="nombres" aria-describedby="nombres">
					</div>
					<div class="input-group mb-0">
						 <div class="input-group-prepend">
						    <span class="input-group-text d-block" id="Apellidos" style="width: 120px;">Apellidos</span>
						 </div>
						 <input type="text" id="da_cli_apellido" class="form-control" placeholder="Apellidos" aria-label="Apellidos" aria-describedby="Apellidos">
					</div>
					<div class="input-group mb-0">
						 <div class="input-group-prepend">
						    <span class="input-group-text d-block" style="width: 120px;">Email</span>
						 </div> 
						 <input type="text" id="da_cli_email" class="form-control" placeholder="Email" aria-label="Email" aria-describedby="Email">
					</div>
					<div class="input-group mb-0">
						 <div class="input-group-prepend" >
						    <span class="input-group-text d-block" style="width: 120px;">Telefono</span>
						 </div> 
						 <input type="text" id="da_cli_telefono" class="form-control" placeholder="Telefono" aria-label="Telefono" aria-describedby="Telefono">
					</div>
					<div class="input-group mb-0">
						 <div class="input-group-prepend">
						    <span class="input-group-text d-block" style="width: 120px;">Idioma</span>
						 </div>
							<select name="idioma" id="idioma" class="form-control">
                  <option value="2">Ingles</option>
                  <option value="1">Español</option>
                  <option value="3">Frances</option>
                  <option value="5">Aleman</option>                 
              </select>
          </div>
					

          <h5 class="beba text-primary mt-2">FORMA DE PAGO:</h5>
                    

<div class="input-group mb-0 fira">
  <div class="input-group-prepend ">
    <div class="input-group-text">
      <input type="radio" id="come_id_1" name="co_id_me" value="1"  checked >
    </div>
  </div>
  <label for="come_id_1" class="form-control bg-light" >Pago con Tarjeta</label>
</div>
<div>
	<img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQFst4-LpqgC7SZQrLoEqil6WOxEuvvVRxWHg&usqp=CAU" class="img-fluid">

</div>
					  
               
                    


				</form>
			
		</div>
    <div class="p-4 bg-primary text-center">
      <button id="btn_po_enviar" class="btn btn-secondary d-block w-100" onclick="po_enviar()"> ENVIAR MI ORDEN US$<b class="costo_total"></b><span class="cargador"></span></button>
    </div>
			
		</div>
		<div class="col-md-3"></div>
	</div>
		

	</div>


<div id="paso_4" style="display: none; position: absolute;" class="position-absolute" >
	<h3>Felicidades!!</h3>
	<p>Muchas gracuas por su compra<br><br>Su Pedido Fue recibido correctamente con los siguientes detalles:<br> 
		Numero de Orden:<b class="fl_codigo"></b><br>
		Nombre:<b class="fl_nombre"></b><br>
		Servicio:<b class="se_nombre"></b><br>
		Total a Pagar:<b class="costo_total"></b><br>
		Fecha de Inicio:<b class="fl_fecha_inicio"><?= $fecha->f ?></b><br>

	</p>
	<p>
		Estaremos contactandole lo mas pronto posible para coordinar los detalles de su viaje<br>Atentamente<br><b>Andean Lodges</b>

	</p>
	<h3>Realizar el Pago</h3>
	<iframe src="https://pagolink.niubiz.com.pe/pagoseguro/ANDEANLODGES/1145955" frameborder="0" width="100%" height="450"></iframe>
</div>
</div>
<script type="text/javascript">
$(function() {
	$( "#f" ).datepicker({
		changeMonth: true,
		changeYear: true,
		dateFormat:'yy-mm-dd',
		showAnim:'slide',
		minDate:'+1D'


	});			
			
			
});
function cambiar_fecha_viaje() {

	window.location.assign('?lg=<?= $_GET['lg'] ?>&ise=<?= $_GET['ise'] ?>&f='+$('#f').val());
	$('#t_tarifas tbody').html('<tr><td class="text-center p-4" colspan="4"><i class="fa fa-circle-notch fa-w-16 fa-spin fa-lg"></i> Cargando</td></tr>');	

}
function marcar(i) {
	$('.marcador').removeClass('bg-secondary');
	$('#marcador_'+i).addClass('bg-secondary');
}
function ventana_seleccionar() {
		marcar(1);
		costo_total = 0;
		//$('.costo_total').html(costo_total);
		$('#paso_1').show('fade');
		$('#paso_3').hide('slide');
		
}
function ventana_finalizar() {
		marcar(3);
		costo_total = 0;
		$('#paso_3').hide('slide');
		$('#paso_4').show('fade');
		
}
function ordenar_compra(paxs,costo) {
		marcar(2);
		costo_total = costo * paxs;

		$('#cantidad_adultos_extranjero').val(paxs);
		$('.costo_total').html(costo_total.toFixed(2));
		$('#paso_1').hide('fade');
		$('#paso_3').show('slide');
		
}
function po_enviar() {
	//procesar pedido
	

     	var valido = cu_validar_informacion();
     	if (valido) {
			//window.location.assign('?c=detalles&m=pagar&nombre='+$('#da_cli_nombre').val()+'&apellido='+$('#da_cli_apellido').val()+'&email='+$('#da_cli_email').val()+'&monto='+$('.costo_total').html());

          $('#btn_po_enviar').prop('disabled', true);
          $('#btn_po_enviar .cargador').html(' <i class="fa fa-circle-notch fa-w-16 fa-spin fa-lg"></i>');

	        var pedidos='[';
	        var i = 0;
	        $('#t_po tbody tr').each(function(){
	                if(i>0)
	                    pedidos+=',';
	                pedidos+='{"po_id_pd":"'+$(this).attr('ipd')+'","po_cantidad":"'+$(this).find('.po_cantidad').val()+'","po_precio":"'+$(this).attr('pu')+'","po_id_mo":"1","po_id_re":"","po_id_rh":"","po_id_mz":"","po_observaciones":"'+$(this).find('.po_observaciones').html()+'", "po_opcionales":"'+$(this).find('.po_opcionales').html()+'", "po_seleccionables":"'+$(this).find('.po_seleccionables').html()+'"}';
	                i++;  
	        });
	        pedidos+=']';
	      
	        var formData={fl_fecha_inicio:$('#f').val(),cantidad_adultos_extranjero:$('#cantidad_adultos_extranjero').val(),fl_precio_total: $('.costo_total').html(),da_id_mo:2,pedidos:pedidos,da_observaciones:$('#da_observaciones').val(),da_entrega_forma:"D",fl_nombre:$('#da_cli_nombre').val() + ' ' +$('#da_cli_apellido').val(),da_cli_telefono:$('#da_cli_telefono').val(),cli_email:$('#da_cli_email').val(),se_codigo:$('#se_codigo').val(),servicio_nombre:$('#se_nombre').html(), de_cantidad_adultos_extranjero:$('#de_cantidad_adultos_extranjero').val(),idioma:$('#idioma option:selected').val() ,co_id_me:$( 'input:radio[name=co_id_me]:checked').val()};
	        $.ajax({
	            url:"?c=files&m=guardar",
	            type:"POST",
	            data:formData,
	            dataType:'json', 
	            success:function(data){
	                if (data.error==0) {
											//window.location.assign('?c=detalles&m=pagar&fl'+data.file);
											$('.fl_codigo').html(data.myid);
											$('.fl_nombre').html($('#da_cli_nombre').val() + ' ' +$('#da_cli_apellido').val());
											$('.se_nombre').html($('#se_nombre').html()	);
											ventana_finalizar();
	                }else{
	                    swal('Sistema','Error inesperado','info');                      
	                }
	                
	            },
	            error: function (xhr, ajaxOptions, thrownError) {
	                  swal("",xhr.status + ' '+thrownError , "warning");
                    $('#btn_po_enviar').prop('disabled', false);
                    $('#btn_po_enviar .cargador').html('');
	                       
	            }
	        });
        }
    
	
	
}
function cu_validar_informacion() {
	var retorno = true
	var faltantes = '';
	if (!$('#da_cli_nombre').val()) {
		faltantes += ' Nombre,';
		retorno =false;
	}
	if (!$('#da_cli_telefono').val() || !$('#da_cli_email').val()) {
		faltantes += ' Telefono o email,';
		retorno =false;
	}
	if (!retorno) {
		swal('Informacion requerida','Por favor complete su:'+faltantes,'info');
	}
	return retorno;
}
</script> 
     
</body>
</html>
