<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class model_kardex extends CI_Model {
	public function listar($tipo = '', $f_ini = '',$f_fin=''){
        $this->db->select("kx.*,pd.pd_producto,un.un_unidad, us_nom as us_nombres,are.are_area, case kx.kx_tipo  when 'O' then 'Salida' when 'A' then 'Stock Ini' when 'I' then 'Entrada' else 'Baja' end as 'tipo'");
       

        $this->db->from('kardex kx');
        $this->db->join('productos pd', 'kx.kx_id_pd = pd.pd_id');
        $this->db->join('areas are', 'kx.kx_id_al = are.are_id');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id');
        $this->db->join('usuario us', 'kx.kx_id_us_reg = us.us_cod');
        if($tipo != '') $this->db->where_in('kx.kx_tipo',$tipo);
        if($f_ini != '') $this->db->where('kx.kx_fecha >= ',$f_ini);
        if($f_fin != '') $this->db->where('kx.kx_fecha <= ',$f_fin);
        return $this->db->get()->result();
        //echo $this->db->last_query();


	}
    public function listar_movimientos($id_almacen, $id_producto){
        $this->db->select('kx.*');
        $this->db->from('kardex kx');
        //$this->db->join('usuarios us', 'kx.kx_id_us_reg = us.us_id');
        $this->db->where('kx.kx_id_al',$id_almacen);
        $this->db->where('kx.kx_id_pd',$id_producto);
        //importante ordenar para calcular los saldos
        $this->db->order_by('kx.kx_fecha','ASC');
        return $this->db->get()->result();
        //echo $this->db->last_query();
    }
    public function registro($id){
        $this->db->where('kx_id',$id);
        $this->db->where('kx_estado',1);
		return $this->db->get('kardex')->row();
	}
    public function buscar($termino){
        $this->db->like('kx_producto',$termino);
        $this->db->where('kx_estado',1);
		return $this->db->get('kardex')->result();
	}
    
    public function guardar($kardex){
          $this->db->where('sk_id_al', $kardex['kx_id_al']);
          $this->db->where('sk_id_pd', $kardex['kx_id_pd']);
          if($this->db->get('stock')->row()){
            $this->db->set('sk_stock', 'sk_stock + '.$kardex['kx_cantidad'], FALSE);
            $this->db->where('sk_id_al', $kardex['kx_id_al']);
            $this->db->where('sk_id_pd', $kardex['kx_id_pd']);
            $this->db->update('stock');
          }else{
            $data_stock = array(
              'sk_id_al' =>  $kardex['kx_id_al'],
              'sk_id_pd'=> $kardex['kx_id_pd'],
              'sk_stock'=> $kardex['kx_cantidad'],
              'sk_fecha'=> date('Y-m-d H:s:i'),
              'sk_id_gr'=> 1
            );
            $this->db->insert('stock', $data_stock);
          }
          $this->db->insert('kardex', $kardex);       
     }
     public function insertar($kardex){
          $this->db->insert('kardex', $kardex);       
     }
     public function remover($id){
     	$this->db->trans_start();
        $data = array();
        $this->db->set('kx_estado',0);
        $this->db->where('kx_id', $id)->update('kardex', $data);
     	$this->db->trans_complete();	
     }
	public function eliminar($id){
		$this->db->where('kx_id',$id);
		$this->db->delete('kardex');	
	}


}
?>